/*
 * Decompiled with CFR 0.152.
 */
package sidconverter.gui;

import emulator.GUI.PersistentFrame;
import emulator.shell.GUI.ConsoleOutputStream;
import emulator.shell.GUI.ConsoleWriteEvent;
import emulator.shell.GUI.LogPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.SimpleAttributeSet;

public class AnalyzerFrame
extends PersistentFrame
implements LogPanel {
    private JPanel contentPane;
    private JTextPane content;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AnalyzerFrame frame = new AnalyzerFrame();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public AnalyzerFrame() {
        super("AnalyzerFrame", "SID Converter");
        this.setTitle("SID Analysis");
        this.setBounds(100, 100, 500, 500);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JButton btnOk = new JButton("OK");
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnalyzerFrame.this.onClose();
            }
        });
        this.contentPane.add((Component)btnOk, "South");
        this.content = new JTextPane();
        this.content.setBorder(new TitledBorder(null, "Log", 4, 2, null, null));
        this.content.setEditable(false);
        this.contentPane.add((Component)new JScrollPane(this.content), "Center");
    }

    protected void onClose() {
        this.savePosition();
        this.setVisible(false);
    }

    @Override
    public void write(String text, SimpleAttributeSet attributes) {
        SwingUtilities.invokeLater(new ConsoleWriteEvent(this, text, attributes));
    }

    @Override
    public JTextPane getContentFrame() {
        return this.content;
    }

    public PrintStream createOut() {
        ConsoleOutputStream out = new ConsoleOutputStream(this, Color.gray, false);
        return new PrintStream(out);
    }

    public PrintStream createErr() {
        ConsoleOutputStream err = new ConsoleOutputStream(this, Color.red, true);
        return new PrintStream(err);
    }
}

